VERSION 2.00
Begin Form frmNote 
   Caption         =   "MiniNotepad"
   ClientHeight    =   3195
   ClientLeft      =   1320
   ClientTop       =   4515
   ClientWidth     =   4665
   Height          =   3600
   Left            =   1260
   MDIChild        =   -1  'True
   ScaleHeight     =   3195
   ScaleWidth      =   4665
   Top             =   4170
   Width           =   4785
   Begin FMSG fmsg1 
      frmName         =   "note"
      Left            =   0
      Top             =   0
   End
   Begin TextBox txtText 
      BorderStyle     =   0  'None
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2895
      Left            =   30
      MultiLine       =   -1  'True
      TabIndex        =   0
      Top             =   30
      Width           =   4245
   End
End
'================================================================================
'
'   note.frm
'
'   This is a simple notepad form that uses the FMSG.VBX custom control
'
'================================================================================
'Change History:
'
    Const cVersion = "961023"

'   Date    who     Description
'   ======= ======= ===============================
'
'================================================================================
'NOTES:
'
'================================================================================
'Turn on my favorite options:

    Option Explicit
    Option Base 1

'================================================================================
'Local variables:

    'Basic information
        Dim fname As String         'filename of this file
        Dim IsChanged As Integer    'TRUE - if the text has been changed

    'Last find parameters:
        Dim lastTexttofind As String
        Dim lastCase As Integer
        Dim lastWhole As Integer
        Dim lastStart As Integer
        Dim Start As Integer

Sub capUpdate ()

    Dim cc As String

    If Len(fname) Then
        cc = fname
    Else
        cc = "(Untitled)"
    End If

    If IsChanged Then
        cc = cc & " *"
    End If

    Me.Caption = cc

End Sub

Sub changedSet (IsC As Integer)

    If IsC <> IsChanged Then
        IsChanged = IsC
        If IsChanged Then
            fBusySet fmsg1, True
        End If
        capUpdate
    End If

End Sub

Sub findDialog ()

    fCall5 fmsg1, "DLGFIND", "SHOW", lastTexttofind, "" & fmsg1.hObj, "" & Start, "" & lastWhole, "" & lastCase

End Sub

Sub fmsg1_Exec (hBuff As Integer, IsDone As Integer)
    
    Dim ee As String
    Dim pp As Integer

    On Error Resume Next
    Err = 0

    Select Case fVerb(hBuff)
        Case "CLOSE"
            If OktoClose(ee) Then
                fRet1 hBuff, "0"
                Unload Me
                Exit Sub
            Else
                fRet1 hBuff, "-1"
            End If

        Case "NEW"
            fBusySet fmsg1, True
        
        Case "SAVE"
            If meSave(ee) Then
                fCall1 fmsg1, "msg", "warn", ee
            End If

        Case "SAVE.AS"
            fCall1 fmsg1, "msg", "warn", "Save As command not completed!"

        Case "OPEN"
            '???    this can easily be replaced with code to open a standard dialog
            meOpen
        
        Case "PRINT"
            fCall1 fmsg1, "msg", "warn", "Print command not completed!"

        Case "EDIT.CUT"
            clipboard.Clear
            clipboard.SetText txtText.SelText, CF_TEXT
            txtText.SelText = ""
        
        Case "EDIT.PASTE"
            If txtText.SelLength <> 0 Then
                txtText.SelText = clipboard.GetText(CF_TEXT)
            Else
                pp = txtText.SelStart
                txtText = Left$(txtText, pp) & clipboard.GetText(CF_TEXT) & Mid$(txtText, pp + 1)
                txtText.SelStart = pp + Len(clipboard.GetText(CF_TEXT))
            End If
        
        Case "EDIT.COPY"
            clipboard.Clear
            clipboard.SetText txtText.SelText, CF_TEXT
        
        Case "FIND.DLG"
            findDialog

        Case "FIND"
            lastTexttofind = fIn1(hBuff)
            Start = Val(fIn2(hBuff))
            lastStart = Start
            lastWhole = Val(fIn3(hBuff))
            lastCase = Val(fIn4(hBuff))
            meFindNext
        
        Case "FIND.NEXT"
            meFindNext
        
        Case Else
            fmsgExecDefault Me, fmsg1, hBuff
    End Select

    fmsgErrCk hBuff

End Sub

Sub Form_Activate ()
    fEventActivate fmsg1
End Sub

Sub Form_Load ()

    capUpdate

End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)

    Dim ee As String

    If UnloadMode <> 1 Then         'if close caused by User directly
        If Not OktoClose(ee) Then
            Cancel = True
            fCall1 fmsg1, "msg", "warn", ee & " while trying to close.  Close cancelled."
        End If
    End If

End Sub

Sub Form_Resize ()

    On Error Resume Next

    If Me.WindowState <> 1 Then
        txtText.Move 0, 0, Me.ScaleWidth, Me.ScaleHeight
    End If

End Sub

Sub meFindNext ()

    '

    Dim tosearch As String
    Dim pp As Integer
    Dim tofind As String
    Dim st As Integer

    If Len(lastTexttofind) = 0 Then
        findDialog
    Else        'do the work
        tosearch = txtText            'get the text
        If Not lastCase Then
            tosearch = UCase$(tosearch)
        End If
        tofind = lastTexttofind
        If Not lastCase Then
            tofind = UCase$(tofind)
        End If
        If lastWhole Then
            tofind = " " & tofind & " "
        End If
        st = txtText.SelStart + 2
        If lastStart Or st = 0 Then
            st = 1
        End If
        lastStart = False       'reset the lastStart function
            
        pp = InStr(st, tosearch, tofind)

        If pp > 0 Then
            fCall1 fmsg1, "msg", "show", "Found."
            If lastWhole Then
                txtText.SelStart = pp - 1
                txtText.SelLength = Len(tofind)
            Else
                txtText.SelStart = pp - 1
                txtText.SelLength = Len(tofind)
            End If
        Else
            fCall1 fmsg1, "msg", "Warn", """ & tofind & "" not found!"
        End If
    End If

End Sub

Sub meOpen ()

    Dim aa As String
    Dim ff As Integer

    On Error Resume Next
    
    fCall1 fmsg1, "msg", "msg", ""

    aa = InputBox("Please enter a filename", "Open Note", "readme.txt")
    
    If Len(aa) <> 0 Then        'if the user gave us a name
        
        Err = 0                     'clear all errors first
        ff = FreeFile               'grab a file handle and try to open the file
        Open aa For Input As #ff
        
        If Err Then         'if errored
            fCall1 fmsg1, "msg", "warn", Error$(Err) & " occurred trying to load file."
            Err = 0
            Exit Sub
        Else
            Close #ff           'close the file
            
            fname = aa          'save the file name
            
            txtText = strfromfile(fname)        'load the file
            
            changedSet False            'reset the changed flag
            capUpdate                   'update the caption
        End If
    
    End If

End Sub

Function meSave (ee As String) As Integer

    'performs a save.  Returns TRUE on errors

    'RET:   True - on errors

    'OUT:   ee - an error message, if returned TRUE

    '???TODO:   add code to save the note

    ee = "Save command not completed"
    meSave = True

End Function

Function OktoClose (ee As String) As Integer

    'returns TRUE if it is ok to exit/close

    'RET:   True - if not ok to close the window

    'OUT:   ee - reason why you can't close

    OktoClose = True         'assume YES

    If IsChanged Then       'if the user changed the text
        Select Case MsgBox("Text has been changed.  Save changes?", MB_ICONQUESTION + MB_YESNOCANCEL, "Save Changes?")
            Case IDYES
                OktoClose = Not meSave(ee)         'return the result of the save.  (If save fails, then NOT Ok to Exit)
                
            Case IDCANCEL
                ee = "User cancelled close"
                OktoClose = False
                
            Case IDNO
                OktoClose = True
                
        End Select
    End If

End Function

Sub txtText_Change ()
    changedSet True
End Sub

